' Ten kod pochodzi z ksiki "ASP.NET 2.0. Gotowe rozwizania" autorstwa
' Imara Spaanjaarsa, Paula Wiltona and Shawna Livermore, wydanej przez Wrox.
' Polska edycja: Wydawnictwo Helion. 
' Copyright 2006 by Wiley Publishing Inc.
' Informacja o tej ksice jest dostpna na stronie www.wrox.com.  
' Odwied p2p.wrox.com aby podyskutowa o tym kodzie na forach Wrox.

Imports System.Drawing
Imports System.Drawing.Imaging

''' <summary>
''' Klasa Helpers dostarcza kilku metodu uytkowych wykorzystywanych w ramach witryny.
''' </summary>
Public Class Helpers

#Region "Konstruktor(y)"

  ''' <summary>
  ''' Ukryj konstruktor, aby unikn tworzenia egzemplarzy klasy Helpers.
  ''' </summary>
  Private Sub New()
  End Sub

#End Region

#Region "Metody publiczne"

  ''' <summary>
  ''' Skaluje obraz do okrelonej maksymalnej szerokoci
  ''' </summary>
  ''' <param name="fileNameIn">Pena cieka do obrazu, ktry ma by przeskalowany.</param>
  ''' <param name="fileNameOut">Pena cieka do miniaturki, ktra ma by stworzona.</param>
  ''' <param name="maxWidthOrHeight">Maksymalna szeroko obrazu.</param>
  ''' <remarks>Jesli <paramref name="fileNameIn" /> odpowiada <paramref name="fileNameOut" /> orygina jest nadpisywany.</remarks>
  Public Shared Sub ResizeImage(ByVal fileNameIn As String, ByVal fileNameOut As String, ByVal maxWidthOrHeight As Integer)
    Dim portrait As Boolean = False
    Dim bmpSource As Bitmap = Nothing

    ' Otwrz obraz
    bmpSource = New Bitmap(fileNameIn)

    Dim originalSize As Size = bmpSource.Size
    Dim newSize As Size = New Size(0, 0)

    bmpSource.Dispose()

    Dim maxHeightDecimal As Decimal = Convert.ToDecimal(maxWidthOrHeight)
    Dim maxWidthAsDecimal As Decimal = Convert.ToDecimal(maxWidthOrHeight)

    Dim resizeFactor As Decimal

    If (originalSize.Height > originalSize.Width) Then
      ' Orientacja pionowa
      resizeFactor = Convert.ToDecimal(Decimal.Divide(originalSize.Height, maxHeightDecimal))
      newSize.Height = maxWidthOrHeight
      newSize.Width = Convert.ToInt32(originalSize.Width / resizeFactor)
    Else
      ' Orientacja pozioma lub kwadrat
      resizeFactor = Convert.ToDecimal(Decimal.Divide(originalSize.Width, maxWidthAsDecimal))
      newSize.Width = maxWidthOrHeight
      newSize.Height = Convert.ToInt32(originalSize.Height / resizeFactor)
    End If

    Dim mySourceBitmap As Bitmap = Nothing
    Dim myTargetBitmap As Bitmap = Nothing
    Dim myGraphics As Graphics = Nothing

    Try
      mySourceBitmap = New Bitmap(fileNameIn)

      Dim newWidth As Integer = newSize.Width
      Dim newHeight As Integer = newSize.Height

      myTargetBitmap = New Bitmap(newWidth, newHeight)

      myGraphics = Graphics.FromImage(myTargetBitmap)

      myGraphics.InterpolationMode = _
                System.Drawing.Drawing2D.InterpolationMode.HighQualityBicubic

      myGraphics.DrawImage(mySourceBitmap, New Rectangle(0, 0, newWidth, newHeight))
      mySourceBitmap.Dispose()

      ' Zapisz nowy obraz
      myTargetBitmap.Save(fileNameOut, ImageFormat.Jpeg)
    Catch
      Throw
    Finally
      If (myGraphics IsNot Nothing) Then
        myGraphics.Dispose()
      End If
      If mySourceBitmap IsNot Nothing Then
        mySourceBitmap.Dispose()
      End If
      If myTargetBitmap IsNot Nothing Then
        myTargetBitmap.Dispose()
      End If
    End Try

  End Sub


  Public Shared Function CreateGridView() As GridView
    Dim myGridView As GridView = New GridView
    myGridView.AutoGenerateColumns = False
    myGridView.ShowFooter = True
    myGridView.Width = Unit.Percentage(100)
    myGridView.BorderWidth = Unit.Pixel(1)

    myGridView.HeaderStyle.BackColor = System.Drawing.Color.FromName("#ffb49f")
    myGridView.HeaderStyle.ForeColor = System.Drawing.Color.White
    myGridView.HeaderStyle.HorizontalAlign = HorizontalAlign.Left
    myGridView.HeaderStyle.Font.Name = "Arial"

    myGridView.RowStyle.BackColor = System.Drawing.Color.White
    myGridView.RowStyle.ForeColor = System.Drawing.Color.Black
    myGridView.RowStyle.Font.Name = "Arial"

    myGridView.FooterStyle.Font.Bold = True
    myGridView.FooterStyle.Font.Name = "Arial"

    Dim myGridViewColumn As New BoundField
    myGridViewColumn.HeaderText = "Tytu"
    myGridViewColumn.DataField = "Title"
    myGridView.Columns.Add(myGridViewColumn)

    myGridViewColumn = New BoundField
    myGridViewColumn.HeaderText = "Ilo"
    myGridViewColumn.DataField = "Quantity"
    myGridViewColumn.ItemStyle.HorizontalAlign = HorizontalAlign.Right
    myGridView.Columns.Add(myGridViewColumn)

    myGridViewColumn = New BoundField()
    myGridViewColumn.HeaderText = "Cena"
    myGridViewColumn.DataField = "Price"
    myGridViewColumn.DataFormatString = "{0:c}"
    myGridViewColumn.ItemStyle.HorizontalAlign = HorizontalAlign.Right
    myGridView.Columns.Add(myGridViewColumn)

    myGridViewColumn = New BoundField()
    myGridViewColumn.HeaderText = "Suma"
    myGridViewColumn.DataField = "SubTotal"
    myGridViewColumn.DataFormatString = "{0:c}"
    myGridViewColumn.ItemStyle.HorizontalAlign = HorizontalAlign.Right
    myGridViewColumn.FooterStyle.HorizontalAlign = HorizontalAlign.Right
    myGridView.Columns.Add(myGridViewColumn)

    Return myGridView
  End Function

  Public Shared Function GetHtmlFromControl(ByVal theControl As WebControl) As String
    Dim myStringBuilder As StringBuilder = New StringBuilder()
    Dim myStringWriter As System.IO.StringWriter = _
          New IO.StringWriter(myStringBuilder)
    Dim myHtmlTextWriter As HtmlTextWriter = New HtmlTextWriter(myStringWriter)
    theControl.RenderControl(myHtmlTextWriter)
    Return myStringBuilder.ToString()
  End Function

  Public Shared Sub SendConfirmationMessage( _
      ByVal theShoppingCart As ShoppingCart, ByVal orderId As Integer, _
      ByVal emailAddress As String)

    Try
      Dim myGridView As GridView = CreateGridView()
      myGridView.DataSource = theShoppingCart.Items
      myGridView.DataBind()

      If myGridView.Rows.Count > 0 Then
        myGridView.FooterRow.Cells(0).Text = "Razem:"
        myGridView.FooterRow.Cells(3).Text = _
                 String.Format("{0:c}", theShoppingCart.Total)

        Dim theSubject As String = "Twoje zamwienie w Sklepie Internetowym Wrox"
        Dim theMessage As String = My.Computer.FileSystem.ReadAllText _
          (AppConfiguration.ConfirmationMessageLocation)

        Dim mySmtpClient As New System.Net.Mail.SmtpClient
        theMessage = theMessage.Replace("##ShoppingCart##", _
                GetHtmlFromControl(myGridView))
        theMessage = theMessage.Replace("##OrderNumber##", orderId.ToString())
        mySmtpClient.Send("You@YourProvider.Com", emailAddress, theSubject, theMessage)
      End If
    Catch ex As Exception
    End Try
  End Sub

#End Region

End Class
